<?php
	/** @var mixed $schemaType */
	/** @var mixed $headContents */
	/** @var mixed $bodyContents */
	/** @var mixed $breadcrumbs */
	/** @var mixed $shortcodeParser */

	/** @var mixed $cityName */
	/** @var mixed $stateName */
	/** @var mixed $stateNameShorthand */
	/** @var mixed $cityUrl */
	/** @var mixed $mapKey */

	// Gets the H1, assigns it to the $h1 variable, and removes it from the page
	$h1Regex = "/<h1.*?>(.+?)<\/h1>/ism";
	preg_match($h1Regex, $bodyContents, $h1Matches);
	$bodyContents = preg_replace($h1Regex, "", $bodyContents, 1);
	$h1 = $h1Matches[1];
    $h3 = CMSInternals::getLastH3($bodyContents);
    CMSInternals::deleteLastH3($bodyContents);	
?>
<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/<?= $schemaType; ?>">
	<head>
		<?php include(__DIR__  . "/../includes/meta.php"); ?>
		<?= $headContents; ?>
	</head>
	<body>
		<?php include(__DIR__ . "/../includes/navigation.php"); ?>
		<main id="content">
			<div class="bg-white">
				<div class="container-fluid">
					<section class="row py-xl-5" id="city">
						<div class="col-xl-9 col-lg-10 col-12 mx-auto p-3 p-lg-5">
							<?= $breadcrumbs; ?>
							<h1><?= $h1 ?></h1>
							<picture>
								<img src="<?= $featuredImage ?>" alt="<?= $this->pageName ?>" class="img-r-dynamic">
							</picture>
							<?= $bodyContents; ?>
							<?php
								if (!$disableGeneratedMap){
									if ($cityUrl != ""){
										?>
										<div class="text-center">
											<div class="my-3">
												<a class="btn btn-primary" target="_blank" href="<?= $cityUrl; ?>"><?= $cityName; ?>, <?= $stateName; ?></a>
											</div>
										</div>
										<?php
									}
									?>
									<div class="ratio ratio-21x9 mb-3">
										<iframe src="https://www.google.com/maps/embed/v1/place?key=<?= $mapKey ?>&q=<?= preg_replace("/[\s]/i", "+", $cityName); ?>+<?= preg_replace("/[\s]/i", "+", $stateName); ?>"></iframe>
									</div>
									<?php
								}
							?>
						</div>
					</section>
					<?php include(__DIR__ . "/../includes/cta.php"); ?>
				</div>
			</div>	
		</main>
		<?php include(__DIR__ . "/../includes/footer.php"); ?>
	</body>
</html>
