<?php

	namespace ThemeImporter;

	use Accounts\Attributes\RequireLogin;
	use Accounts\Attributes\RequirePermission;
	use Nox\Http\Attributes\UseJSON;
	use Nox\Http\Exceptions\NoPayloadFound;
	use Nox\Http\JSON\JSONError;
	use Nox\Http\JSON\JSONResult;
	use Nox\Http\JSON\JSONSuccess;
	use Nox\Http\Request;
	use Nox\RenderEngine\Exceptions\LayoutDoesNotExist;
	use Nox\RenderEngine\Exceptions\ParseError;
	use Nox\RenderEngine\Exceptions\ViewFileDoesNotExist;
	use Nox\RenderEngine\Renderer;
	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\Attributes\RouteBase;
	use Nox\Router\BaseController;
	use Roles\PermissionCategories;
	use ThemeImporterService;

	#[Controller]
	#[RouteBase("/uplift/theme-importer")]
	class ThemeImporterController extends BaseController
	{
		/**
		 * @return string
		 * @throws LayoutDoesNotExist
		 * @throws ParseError
		 * @throws ViewFileDoesNotExist
		 */
		#[Route("GET", "/")]
		#[RequireLogin]
		#[RequirePermission(PermissionCategories::THEME_IMPORTER)]
		public function mainView(): string
		{
			return Renderer::renderView(
				viewFileName: "theme-importer/main.php"
			);
		}

		/**
		 * @param Request $request
		 * @return JSONResult
		 */
		#[Route("GET", "/download-theme")]
		#[RequireLogin]
		#[UseJSON]
		#[RequirePermission(PermissionCategories::THEME_IMPORTER)]
		public function downloadTheme(Request $request): JSONResult
		{
			// Gets the theme URL string and overwrite value
			$theme = $request->getQueryValue("theme-url");
			$overwrite = $request->getQueryValue("overwrite");

			// Downloads the theme from the provided URL
			$file = ThemeImporterService::downloadFile($theme);

			// Installs the theme, then returns the success or error message
			return ThemeImporterService::extractAndDeleteFile($file, $overwrite);
		}
	}