<?php

	namespace TermsOfUse;

	use Accounts\Attributes\RequireLogin;
	use Nox\RenderEngine\Exceptions\LayoutDoesNotExist;
	use Nox\RenderEngine\Exceptions\ParseError;
	use Nox\RenderEngine\Exceptions\ViewFileDoesNotExist;
	use Nox\RenderEngine\Renderer;
	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\Attributes\RouteBase;
	use Nox\Router\BaseController;

	#[Controller]
	#[RouteBase("/uplift")]
	class TermsOfUseController extends BaseController
	{
		/**
		 * @throws ParseError
		 * @throws ViewFileDoesNotExist
		 * @throws LayoutDoesNotExist
		 */
		#[Route("GET", "/terms-of-use")]
		#[RequireLogin]
		public function mainView(): string
		{
			return Renderer::renderView(
				viewFileName: "terms-of-use/main.php",
			);
		}
	}