<?php

	namespace TemplateManager\PageLayouts;

	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	/**
	 * Represents an individual section for a page layout, belonging to a section definition. This object
	 * holds the content for an individual section in the definition.
	 */
	class PageLayoutSection extends ModelClass implements ModelInstance
	{
		public ?int $id = null;
		/**
		 * @var int The Id of the PaageLayoutSectionDefinition that this individual section belongs to.
		 */
		public int $pageLayoutSectionDefinitionId;
		/**
		 * @var ?string The human-readable name of this page section
		 */
		public ?string $sectionName;
		/**
		 * @var int Set to 1 if this page layout section is defined as being the "default content" section for
		 * any pages that implement this layout. The default content section is where importers, OG readers,
		 * and preview readers will try and read content from first before falling back to the first available
		 * section.
		 */
		public int $isDefaultContentSection;
		public int $creationTimestamp;

		public static function getModel(): MySQLModelInterface
		{
			return new PageLayoutSectionModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}

	}