<?php

	namespace System\Updater\PostUpdate;

	use MonologWrapper\MonologWrapper;
	use Nox\ClassLoader\ClassLoader;
	use Nox\ORM\Abyss;

	final class SyncModels extends PostUpdateProcess{
		public function runProcess(): void
		{
			$logger = MonologWrapper::getLogger();
			$modelReflections = ClassLoader::$modelClassReflections;
			$logger->info("Running SyncModels post update process.");
			$abyss = new Abyss();
			$abyss->syncModels($modelReflections);
			$logger->info("Synced Abyss ORM models.");
		}
	}