<?php

	namespace System\Updater\PostUpdate;

	use MonologWrapper\MonologWrapper;
	use Roles\Role;
	use Settings\Settings;
	use Settings\SettingService;
	use System\Updater\PostUpdate\Attributes\RunOnlyOnVersion;

	final class SetHasAllPermsOnValidRoles extends PostUpdateProcess{
		public function runProcess(): void
		{
			$logger = MonologWrapper::getLogger();

			// Should be all lowercase
			$detectedAdminRoleNames = [
				"sysop",
				"sysops",
				"systems operator",
				"administrator",
				"admin",
			];

			/** @var Role[] $allRoles */
			$allRoles = Role::query();

			foreach($allRoles as $role){
				if (in_array(strtolower($role->name), $detectedAdminRoleNames)){
					$role->hasAllPermissions = 1;
					$role->save();
					$logger->info("{$role->name} detected as super admin role name. Gave all permissions upon update.");
				}
			}

		}
	}