<?php

	namespace System\Updater\SystemBuildInformation;

	use Accounts\Attributes\RequireLogin;
	use Nox\Http\Attributes\UseJSON;
	use Nox\Http\JSON\JSONResult;
	use Nox\Http\JSON\JSONSuccess;
	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\Attributes\RouteBase;
	use Nox\Router\BaseController;

	#[Controller]
	#[RouteBase("/uplift/system-build-information")]
	class SystemBuildInformationController extends BaseController{

		#[Route("GET", "/send-updated-info")]
		#[RequireLogin]
		#[UseJSON]
		public function sendUpdatedInfoToMasterControlPanel(): JSONResult
		{
			SystemBuildInformationService::sendUpdatedBuildInformationToControlPanel();
			return new JSONSuccess();
		}

	}