<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Page\Page;
	use Page\PageDatas;
	use ShortcodeParser\Processors\Exceptions\NoPageCurrentlyRendered;
	use ShortcodeParser\Shortcode;
	use ShortcodeParser\ShortcodeTypes;

	/**
	 * Processor class for the state-name-shorthand
	 */
	class GetStateNameShorthand extends Processor {

		protected static array $supportedAttributes = [
			"map-safe",
		];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		/**
		 * @throws NoPageCurrentlyRendered
		 */
		public function runProcessor(): string{
			$shouldFormatToMapSafe = $this->shortcode->getAttribute("map-safe") !== null;

			// Fetch the current page, if any
			$currentPage = Page::getCurrentPage();
			if ($currentPage !== null){
				$stateNameShorthandDatas = $currentPage->getPageDatas(PageDatas::STATE_NAME_SHORTHAND);

				if (empty($stateNameShorthandDatas)){
					// No state name shorthand for this page
					// Return blank
					return "";
				}else{
					// Get the first result
					$stateNameShorthandData = $stateNameShorthandDatas[0];
					$stateNameShorthand = $stateNameShorthandData->value;

					// Does it need to be map-safe?
					if ($shouldFormatToMapSafe){
						$stateName = preg_replace(
							pattern:"@\s@",
							replacement: "+",
							subject: $stateNameShorthand,
						);
					}

					return $stateNameShorthand;
				}
			}else{
				throw new NoPageCurrentlyRendered(
					sprintf(
						"Failed to run %s shortcode. There is no current Uplift CMS page being rendered.",
						ShortcodeTypes::GET_STATE_NAME_SHORTHAND->value,
					)
				);
			}
		}
	}
