<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Nox\ORM\ColumnQuery;
	use Page\Page;
	use Page\PageDatas;
	use Page\PublicationStatus;
	use ShortcodeParser\Processors\Exceptions\NoPageCurrentlyRendered;
	use ShortcodeParser\Shortcode;
	use ShortcodeParser\ShortcodeTypes;

	/**
	 * Processor class for the generate-sitemap shortcode
	 */
	class GenerateSitemap extends Processor {

		protected static array $supportedAttributes = [];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		public function runProcessor(): string{
			/** @var Page[] $pages */
			$pages = Page::query(
				columnQuery: (new ColumnQuery())
					->where("publication_status","=",PublicationStatus::Published->value)
					->and()
					->where("excludeFromSitemap","=",0),
			);

			$sitemap = '<ul class="sitemap-list list-group">';

			foreach($pages as $page){
				$sitemap .= sprintf(
					'<li class="list-group-item">
								<a href="%s">%s</a>
							</li>',
							$page->pageRoute,
							$page->pageName,
					);
			}

			$sitemap .= "</ul>";

			return $sitemap;
		}
	}
