<?php

	namespace Roles;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\Text;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class RolesModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "roles";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = Role::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "name",
					classPropertyName: "name",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "has_all_permissions",
					classPropertyName: "hasAllPermissions",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "can_be_deleted",
					classPropertyName: "canBeDeleted",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "timestamp",
					classPropertyName: "timestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
			];
		}
	}
