<?php

	namespace Roles;

	use Nox\ORM\ColumnQuery;
	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class Role extends ModelClass implements ModelInstance
	{
		public ?int $id = null;
		public string $name;
		public int $hasAllPermissions;
		public int $canBeDeleted;
		public int $timestamp;

		public static function getModel(): MySQLModelInterface{
			return new RolesModel();
		}

		public function __construct(){
			parent::__construct($this);
		}

		/**
		 * Checks if this role has a given permission row in the database
		 */
		public function getPermission(PermissionCategories $categories): Permission | null{
			/** @var Permission $permission */
			$permission = Permission::queryOne(
				columnQuery: (new ColumnQuery())
					->where("permission_id","=",$categories->value)
					->and()
					->where("role_id","=",$this->id)
			);

			return $permission;
		}

		/**
		 * Checks if this role has a given permission row in the database
		 */
		public function hasEnabledPermission(PermissionCategories $categories): bool{

			// If this role is marked as always having all perms, ignore specific checks
			// and always return true
			if ($this->hasAllPermissions === 1){
				return true;
			}

			$permission = $this->getPermission($categories);
			if ($permission !== null){
				return $permission->isEnabled === 1;
			}else{
				return false;
			}
		}
	}