<?php

	namespace Roles;

	use Nox\ORM\Exceptions\NoPrimaryKey;
	use Roles\Exceptions\RoleCannotBeDeleted;
	use ValueError;

	class PermissionsService
	{
		/**
		 * @param Role $role
		 * @param PermissionCategories $category
		 * @param bool $isEnabled
		 * @return Permission
		 * @throws PermissionAlreadyExists
		 */
		public static function createPermission(
			Role $role,
			PermissionCategories $category,
			bool $isEnabled = false,
		): Permission{
			if ($role->getPermission($category) === null) {
				$permission = new Permission();
				$permission->permissionID = $category->value;
				$permission->roleID = $role->id;
				$permission->isEnabled = $isEnabled ? 1 : 0;
				$permission->save();

				return $permission;
			}else{
				throw new PermissionAlreadyExists("Permission {$category->name} already exists for Role {$role->name}");
			}
		}

		/**
		 * @param Permission $permission
		 * @param int|null $permissionID
		 * @param int|null $roleID
		 * @param int|null $isEnabled
		 * @return Permission
		 */
		public static function editPermission(
			Permission $permission,
			int|null $permissionID = null,
			int|null $roleID = null,
			int|null $isEnabled = null,
		): Permission {

			if($permissionID !== null) {
				$permission->permissionID = $permissionID;
			}

			if($roleID !== null) {
				$permission->roleID = $roleID;
			}

			if($isEnabled !== null) {
				$permission->isEnabled = $isEnabled;
			}

			$permission->save();

			return $permission;
		}

		/**
		 * @param Permission $permission
		 * @param int $canBeDeleted
		 * @return void
		 * @throws NoPrimaryKey
		 * @throws RoleCannotBeDeleted
		 */
		public static function deletePermission(
			Permission $permission,
			int $canBeDeleted,
		): void{
			if($canBeDeleted === 0) {
				throw new RoleCannotBeDeleted("This role cannot be deleted.");
			}

			$permission->delete();
		}
	}