<?php

	namespace Roles;

	use System\Deprecated;

	enum PermissionCategories: int
	{
		/** @deprecated  */
		#[Deprecated]
		case MANAGE_GENERAL_PAGES = 1;
		/** @deprecated  */
		#[Deprecated]
		case MANAGE_SERVICE_PAGES = 2;
		/** @deprecated  */
		#[Deprecated]
		case MANAGE_BLOG_PAGES = 3;
		/** @deprecated  */
		#[Deprecated]
		case MANAGE_CITY_PAGES = 4;
		/** @deprecated  */
		#[Deprecated]
		case MANAGE_PROJECT_PAGES = 5;
		case VIEW_PAGE_HISTORY = 6;
		case SEARCH_AND_REPLACE = 7;
		case MANAGE_IMAGES = 8;
		case MANAGE_IMAGE_GALLERIES = 9;
		case MANAGE_TEMPLATE_FILES = 10;
		case ACCESS_CLIENT_IPP_FORM = 11;
		case MANAGE_REDIRECTS = 12;
		case MANAGE_REVIEWS = 13;
		case VIEW_ACTIVITY_LOGS = 14;
		case MANAGE_SETTINGS = 15;
		case MANAGE_USERS = 16;
		case MANAGE_SITEMAPS = 17;
		case MANAGE_ROLES = 18;
		/** @deprecated */
		#[Deprecated]
		case EXPORT_WEBSITE = 19;
		case MANAGE_APACHE = 20;
		case WEBSITE_IMPORTER = 21;
		case SENZU_IMPORTER = 22;
		case EDIT_PAGES = 23;
		case MANAGE_PAGE_ATTRIBUTES = 24;
		case ACCESS_EASY_EDITOR = 25;
		case ACCESS_PAGE_EDITOR = 26;
		case THEME_IMPORTER = 27;

		const PERMISSION_NAMES = [
			1 => "Manage General Pages",
			2 => "Manage Service Pages",
			3 => "Manage Blog Pages",
			4 => "Manage City Pages",
			5 => "Manage Project Pages",
			6 => "View Page History",
			7 => "Search and Replace",
			8 => "Manage Images",
			9 => "Manage Image Galleries",
			10 => "Manage Template Files",
			11 => "Access Client IPP Form",
			12 => "Manage Redirects",
			13 => "Manage Reviews",
			14 => "View Activity Logs",
			15 => "Manage Settings",
			16 => "Manage Users",
			17 => "Manage Sitemaps",
			18 => "Manage Roles",
			19 => "Export Website",
			20 => "Manage Apache",
			21 => "Use External Website Importer",
			22 => "Use Senzu Importer",
			23 => "Edit Pages",
			24 => "Manage Page Attributes",
			25 => "Access Easy Editor",
			26 => "Access Page Editor",
			27 => "Use Theme Importer"
		];

		public static function getByName(string $caseName): ?PermissionCategories{
			foreach(self::cases() as $case){
				if ($case->name === $caseName){
					return $case;
				}
			}

			return null;
		}

		public static function getByValue(int $caseValue): ?PermissionCategories{
			foreach(self::cases() as $case){
				if ($case->value === $caseValue){
					return $case;
				}
			}

			return null;
		}
	}