<?php

	namespace RSS;

	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\Attributes\RouteBase;
	use Nox\Router\BaseController;
	use Page\PageType;

	#[Controller]
	#[RouteBase("/rss")]
	class RSSController extends BaseController
	{

		#[Route("GET", "/all.xml")]
		public function allPagesRSSView(): string
		{
			$content = RSSService::getXMLForPageType(null)->asXML();
			header('Content-type: text/xml');
			header('Pragma: public');
			header('Cache-control: private');
			header('Expires: -1');
			header("Content-Length: " . strlen($content));

			return $content;
		}

		#[Route("GET", "/projects.xml")]
		public function projectsRSSView(): string
		{
			$content = RSSService::getXMLForPageType(PageType::Project)->asXML();
			header('Content-type: text/xml');
			header('Pragma: public');
			header('Cache-control: private');
			header('Expires: -1');
			header("Content-Length: " . strlen($content));

			return $content;
		}

		#[Route("GET", "/blogs.xml")]
		public function blogsRSSView(): string
		{
			$content = RSSService::getXMLForPageType(PageType::Blog)->asXML();
			header('Content-type: text/xml');
			header('Pragma: public');
			header('Cache-control: private');
			header('Expires: -1');
			header("Content-Length: " . strlen($content));

			return $content;
		}

	}