<?php
	namespace PageEditor;

	use Page\PageAttribute\PageAttribute;
	use Page\PageAttribute\PageAttributePageValue;

	class PageAttributeResponse{
		public int $id;
		public int $pageAttributeID;
		public int $pageID;
		public string $name;
		public string $value;

		public static function fromPageAttributePageValue(PageAttributePageValue $pageAttributePageValue): PageAttributeResponse{
			// Fetch the actual PageAttribute to get the name from
			/** @var PageAttribute $pageAttribute */
			$pageAttribute = PageAttribute::fetch($pageAttributePageValue->pageAttributeID);

			$response = new PageAttributeResponse();
			$response->id = $pageAttributePageValue->id;
			$response->pageAttributeID = $pageAttributePageValue->pageAttributeID;
			$response->pageID = $pageAttributePageValue->pageID;
			$response->name = $pageAttribute->name;
			$response->value = $pageAttributePageValue->value;

			return $response;
		}
	}