<?php

	namespace PageArchives;

	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class PageArchive extends ModelClass implements ModelInstance
	{

		public ?int $id = null;
		public int $pageID;
		public int $archivedTimestamp;
		public string $pageName;
		public string $pageType;
		public string $pageRoute;
		public int $pageRouteIsRegex;
		public string $pageLayout;
		public string $pageHead;
		public string $pageBody;
		public int $creationTime;
		public int $excludeFromSitemap;
		public int $excludeSchemaInjection;
		public int $publicationStatus;
		public int $publicationTimestamp;

		public static function getModel(): MySQLModelInterface
		{
			return new PageArchivesModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}
	}