# Page Object Documentation

## Fetching Page Attributes
Keep in mind, for the below methods, the following vocabulary:
* Attribute Value ID - The ID for the row that represents that value that specific page has assigned
* Attribute ID - The ID for the Page Attribute and not specifically the Page Attribute Value that page is assigned.

For example, an "Author" attribute could have ID 1, but it can be assigned to 20 pages. Each assignments gets its own ID. That individual page assignment ID is an "attribute value ID".

### By Attribute Value ID
With any given page instance and an attribute value ID (not an attribute ID) you can use the following format.
```php
$page = ?
$attributeValueID = 1;

try{
    $pageAttributeValue = $page->getAttributeValue($attributeValueID);
}catch(\Uplift\Exceptions\NoObjectFound $e){
    // No page attribute value found with that attribute value ID
}

print($pageAttributeValue->value);
```

### By Attribute ID
This alternative allows you to fetch the page attribute value object using the page attribute ID - not the attribute value ID. This is useful when you, for example, want to include this logic into a more global file (such as a global include or layout file) that renders multiple pages without context.

```php
$page = ?
$attributeID = 1;

try{
    $pageAttributeValue = $page->getAttributeValueFromAttributeID($attributeValueID);
}catch(\Uplift\Exceptions\NoObjectFound $e){
    // No page attribute value found with that attribute ID
}

print($pageAttributeValue->value);
```