<?php

	namespace Page;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class PagesBreadcrumbsModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages_breadcrumbs";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageBreadcrumb::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "pageID",
					classPropertyName: "pageID",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "position",
					classPropertyName: "position",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "label",
					classPropertyName: "label",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "uri",
					classPropertyName: "uri",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
			];
		}
	}
