<?php

	namespace Page;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use NoxEnv;

	#[Model]
	class PageProjectPostTagsModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages_project_post_tags";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageProjectPostTag::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "page_id",
					classPropertyName: "pageID",
					dataType: new Integer(),
					defaultValue: 0,
					isNull: false,
				),
				new ColumnDefinition(
					name: "project_tag_id",
					classPropertyName: "projectTagID",
					dataType: new Integer(),
					defaultValue: 0,
					isNull: false,
				),
			];
		}
	}
