<?php

	namespace Page\PageAttribute;

	class PageAttributeQueryResponse
	{

		public int $id;
		public string $name;
		public int $creationTime;
		public array $pageTypes;

		public static function fromPageAttribute(PageAttribute $pageAttribute): PageAttributeQueryResponse{
			$pageTypes = $pageAttribute->getAvailablePageTypes();

			$queryResponse = new PageAttributeQueryResponse();
			$queryResponse->id = $pageAttribute->id;
			$queryResponse->name = $pageAttribute->name;
			$queryResponse->creationTime = $pageAttribute->creationTime;
			$queryResponse->pageTypes = $pageTypes;

			return $queryResponse;
		}
	}