<?php

	namespace Page\PageAttribute;

	use Nox\ORM\ColumnQuery;
	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;
	use Page\PageAttributes\PageAttributePageType;
	use Page\PageAttributes\PageAttributesModel;

	class PageAttribute extends ModelClass implements ModelInstance
	{

		public ?int $id = null;
		public string $name;
		public int $creationTime;

		public static function getModel(): MySQLModelInterface
		{
			return new PageAttributesModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}

		/**
		 * Sets the page types that this attribute is available to be assigned to
		 */
		public function setAvailablePageTypes(array $pageTypeNames): void{
			$this->clearAvailablePageTypes();

			foreach($pageTypeNames as $pageTypeName){
				$pageAttributePageType = new PageAttributePageType();
				$pageAttributePageType->pageAttributeID = $this->id;
				$pageAttributePageType->pageType = $pageTypeName;
				$pageAttributePageType->save();
			}
		}

		/**
		 * @return PageAttributePageType[]
		 */
		public function getAvailablePageTypes(): array{
			/** @var PageAttributePageType[] $attributePageTypes */
			$attributePageTypes = PageAttributePageType::query(
				columnQuery: (new ColumnQuery())
					->where("page_attribute_id","=",$this->id)
			);

			return $attributePageTypes;
		}

		/**
		 * Deletes all page types associated with this PageAttribute instance
		 */
		private function clearAvailablePageTypes(): void{
			/** @var PageAttributePageType[] $pageAttributePageTypes */
			$pageAttributePageTypes = PageAttributePageType::query(
				columnQuery: (new ColumnQuery())
					->where("page_attribute_id","=",$this->id)
			);

			foreach($pageAttributePageTypes as $pageAttributePageType){
				$pageAttributePageType->delete();
			}
		}
	}