<?php
	namespace ObjectUtils;

	use stdClass;

	class ObjectDehydrator{
		/**
		 * Returns an array of stdClass objects that only contains key-values of each object in the $objects array.
		 * @param object[] $objects
		 * @param string[] $properties
		 * @return stdClass[]
		 */
		public static function getDehydratedObjects(array $objects, array $properties){
			$dehydrated = [];
			foreach($objects as $object){
				$newStdClass = new stdClass();
				foreach($properties as $property){
					$newStdClass->{$property} = $object->{$property};
				}
				$dehydrated[] = $newStdClass;
			}

			return $dehydrated;
		}
	}