<?php

	namespace ImageGallery;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class ImageGalleryMemberModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "image_gallery_members";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = ImageGalleryMember::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "gallery_id",
					classPropertyName: "galleryID",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "image_uri",
					classPropertyName: "imageURI",
					dataType: new VariableCharacter(1024),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "thumb_uri",
					classPropertyName: "thumbURI",
					dataType: new VariableCharacter(1024),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "alt_attribute",
					classPropertyName: "altAttribute",
					dataType: new VariableCharacter(1024),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "position",
					classPropertyName: "position",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "timestamp",
					classPropertyName: "timestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
			];
		}
	}
