<?php

	namespace Google;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\FloatValue;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class GoogleAccountSearchConsoleDataRowsModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "google_account_search_console_data_rows";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = GoogleAccountSearchConsoleDataRow::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "key",
					classPropertyName: "key",
					dataType: new VariableCharacter(255),
					defaultValue: "",
					autoIncrement: false,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "date",
					classPropertyName: "date",
					dataType: new VariableCharacter("255"),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "query",
					classPropertyName: "query",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "page",
					classPropertyName: "page",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "country",
					classPropertyName: "country",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "position",
					classPropertyName: "position",
					dataType: new FloatValue(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "ctr",
					classPropertyName: "ctr",
					dataType: new FloatValue(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "clicks",
					classPropertyName: "clicks",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "impressions",
					classPropertyName: "impressions",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "date_as_unix_timestamp",
					classPropertyName: "dateAsUnixTimestamp",
					dataType: new Integer(),
					defaultValue: 0,
				),
			];
		}
	}
