<?php
	namespace FindAndReplace;

	/**
	 * Why are there multiple stubs? Because to sanitize and render it on the front end, we have to be able
	 * to isolate the match versus the padded preview results around it.
	 */
	class FindResultItem{
		public bool $isPageHead = false;
		public int $start;
		public int $end;
		public FindResultStub $stub;

		public static function fromArray(array $a): FindResultItem{
			$obj = new FindResultItem();
			$obj->isPageHead = $a["isPageHead"] ?? false;
			$obj->start = $a["start"] ?? 0;
			$obj->end = $a["end"] ?? 0;
			$obj->stub = FindResultStub::fromArray($a["stub"]);

			return $obj;
		}
	}