<?php
	namespace FindAndReplace;

	class FindResult{
		public FindResultType $type;
		public ?int $pageID = null;
		public ?string $pageName = null;
		public ?string $filePath = null;
		public ?string $fileName = null;

		/** @var FindResultItem[] $findResults */
		public array $findResults = [];

		public static function fromArray(array $findResult): FindResult{
			$result = new FindResult();
			$result->pageID = $findResult['pageID'];
			$result->pageName = $findResult['pageName'];
			$result->filePath = $findResult['filePath'];
			$result->fileName = $findResult['fileName'];
			$result->type = FindResultType::fromString($findResult['type']);

			foreach($findResult['findResults'] as $findResultItemArray){
				$resultItem = new FindResultItem();
				$resultItem->start = $findResultItemArray['start'];
				$resultItem->end = $findResultItemArray['end'];
				$resultItem->isPageHead = $findResultItemArray['isPageHead'];

				$stub = new FindResultStub();
				$stub->before = $findResultItemArray['stub']['before'];
				$stub->beforeSanitized = $findResultItemArray['stub']['beforeSanitized'];
				$stub->result = $findResultItemArray['stub']['result'];
				$stub->resultSanitized = $findResultItemArray['stub']['resultSanitized'];
				$stub->after = $findResultItemArray['stub']['after'];
				$stub->afterSanitized = $findResultItemArray['stub']['afterSanitized'];

				$resultItem->stub = $stub;

				$result->findResults[] = $resultItem;
			}

			return $result;
		}
	}