<?php
	namespace FindAndReplace\Dtos;

	use FindAndReplace\FindResultItem;

	class FoundPageSectionMatchDto{
		public string $sectionName;
		public string $sectionContent;
		/** @var FindResultItem[] Find result items for the $sectionContent */
		public array $findResultItems = [];

		public static function fromArray(array $a): FoundPageSectionMatchDto{
			$obj = new FoundPageSectionMatchDto();
			$obj->sectionName = $a["sectionName"];
			$obj->sectionContent = $a["sectionContent"];
			$obj->findResultItems = array_map(fn ($subArray) => FindResultItem::fromArray($subArray), $a["findResultItems"]);

			return $obj;
		}
	}