<?php
	namespace Dashboard;

	use Google\GoogleAccount;
	use Google\GoogleAccountSearchConsoleSite;
	use GuzzleHttp\Client;
	use GuzzleHttp\RequestOptions;
	use Nox\ORM\ColumnQuery;
	use Settings\Setting;
	use Settings\Settings;
	use Settings\SettingService;
	use System\HttpHelper;
	use System\System;

	class DashboardService{
		public static function getGoogleOAuthSignInURL(): string{
			$uuid = Setting::getSettingValue(Settings::BUILD_UUID->value);
			$apiKey = Setting::getSettingValue(Settings::UPLIFT_CONTROL_PANEL_API_KEY->value);
			$controlPanelHost = System::getUpliftControlPanelHost();
			$client = new Client();
			$response = $client->request(
				method:"GET",
				uri:$controlPanelHost . "/uplift/build/get-oauth-login-url",
				options:[
					RequestOptions::HEADERS => [
						"Uplift-API-Key"=>$apiKey,
						"Uplift-UUID"=>$uuid,
					],
				],
			);

			$bodyContents = $response->getBody()->getContents();
			/** @var array{status: int, oAuthSignInURL: string} $data */
			$data = json_decode($bodyContents, true);

			return $data['oAuthSignInURL'];
		}

		public static function processOAuthSignIn(): void{
			$payload = $_GET['payload'];

			// $payload is a base64 encoded JSON string with some keys
			/** @var array{email: string, listOfSites: string[]} $data */
			$data = json_decode(base64_decode($payload), true);
			$email = $data['email'];

			// Check if there is a Google Account with this email
			/** @var ?GoogleAccount $localGoogleAccount */
			$localGoogleAccount = GoogleAccount::queryOne(
				columnQuery:(new ColumnQuery())
					->where("email","=",$email)
			);

			if ($localGoogleAccount === null){
				// Create one
				$localGoogleAccount = new GoogleAccount();
				$localGoogleAccount->email = $email;
				$localGoogleAccount->save();
			}else{
				// Clear all sites known to this account, as we just received a fresh list
				/** @var GoogleAccountSearchConsoleSite[] $knownSearchConsoleSites */
				$knownSearchConsoleSites = GoogleAccountSearchConsoleSite::query(
					columnQuery: (new ColumnQuery())
						->where("google_account_row_id","=",$localGoogleAccount->id)
				);

				foreach($knownSearchConsoleSites as $googleAccountSearchConsoleSite){
					$googleAccountSearchConsoleSite->delete();
				}
			}

			// Save the list of search console sites
			$baseURL = HttpHelper::getWebsiteBaseURL();
			$matchingSite = "";
			foreach($data['listOfSites'] as $site){
				$searchConsoleSite = new GoogleAccountSearchConsoleSite();
				$searchConsoleSite->googleAccountRowID = $localGoogleAccount->id;
				$searchConsoleSite->site = $site;
				$searchConsoleSite->save();

				if (rtrim($site, "/") === $baseURL){
					$matchingSite = $site;
				}
			}

			// Set the current active search console Google Account email
			SettingService::saveSetting(
				Settings::ACTIVE_SEARCH_CONSOLE_GOOGLE_ACCOUNT_EMAIL->value,
				$email,
			);

			if (!empty($data['listOfSites'])) {
				if (empty($matchingSite)){
					// Use the first site instead
					$matchingSite = $data['listOfSites'][0];
				}
				// Set the first site in the available sites as the primary site
				SettingService::saveSetting(
					Settings::ACTIVE_SEARCH_CONSOLE_SITE->value,
					$matchingSite,
				);
			}
		}
	}