<?php

	namespace Dashboard;

	use Accounts\Account;
	use Accounts\Attributes\RequireLogin;
	use APIPublic\AuthorizeByAPIKey;
	use Nox\Http\Attributes\UseJSON;
	use Nox\Http\JSON\JSONResult;
	use Nox\Http\JSON\JSONSuccess;
	use Nox\Http\Redirect;
	use Nox\RenderEngine\Renderer;
	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\Attributes\RouteBase;
	use Nox\Router\BaseController;
	use Settings\Setting;
	use Settings\Settings;

	#[Controller]
	#[RouteBase("/uplift/dashboard")]
	class DashboardController extends BaseController{

		#[Route("GET", "/")]
		#[RequireLogin]
		public function dashboardView(): string{
			return Renderer::renderView(
				viewFileName:"dashboard/main.php",
			);
		}

//		#[Route("GET", "/")]
//		#[RequireLogin]
//		public function dashboardView(): string
//		{
//
//			// Check if this is a view for a successful sign-in from the Uplift Control Panel oAuth
//			if (isset($_GET['oAuthSignInSuccess'])){
//				DashboardService::processOAuthSignIn();
//				// Redirect to remove the query parameters
//				http_response_code(302);
//				header("location: /uplift/dashboard");
//				exit();
//			}
//
//			return Renderer::renderView(
//				viewFileName:"dashboard/main.php",
//				viewScope:[
//					"searchConsoleEmail"=>Setting::getSettingValue(
//						Settings::ACTIVE_SEARCH_CONSOLE_GOOGLE_ACCOUNT_EMAIL->value,
//					),
//					"searchConsoleSite"=>Setting::getSettingValue(
//						Settings::ACTIVE_SEARCH_CONSOLE_SITE->value,
//					),
//				],
//			);
//		}
//
//		#[Route("GET", "/get-oauth-sign-in-url")]
//		#[RequireLogin]
//		#[UseJSON]
//		public function getGoogleOAuthSignInURL(): JSONResult
//		{
//			$url = DashboardService::getGoogleOAuthSignInURL();
//
//			return new JSONSuccess([
//				"url"=>$url,
//			]);
//		}
	}