<?php
	namespace Crons\Jobs;

	use Crons\Timers\IntervalTimer;
	use Crons\Timers\Timer;
	use System\Updater\SystemBuildInformation\SystemBuildInformationService;

	/**
	 * A cron job that will send the system's build information to the master control panel.
	 */
	class SendUpdateToControlPanel extends Job {

		public int $lastRunTimestamp;
		public Timer $timer;

		public function __construct(int $lastRunTimestamp){
			$timer = new IntervalTimer();
			$timer->everyXMinutes = 5;

			$this->lastRunTimestamp = $lastRunTimestamp;
			$this->timer = $timer;
		}

		public function getCronTimer(): Timer
		{
			return $this->timer;
		}

		public function isDue(): bool
		{
			/** @var IntervalTimer $timer */
			$timer = $this->getCronTimer();
			$dueTimestamp = $timer->getDueTimestamp($this->lastRunTimestamp);

			return $dueTimestamp <= time();
		}

		public function run(): void
		{
			SystemBuildInformationService::sendUpdatedBuildInformationToControlPanel();
		}
	}