<?php

	namespace Crons;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class CronsRunHistoryModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "crons_run_history";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = CronRunHistory::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "name",
					classPropertyName: "name",
					dataType: new VariableCharacter(500),
					defaultValue: "",
					autoIncrement: false,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "last_run_timestamp",
					classPropertyName: "lastRunTimestamp",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "did_succeed",
					classPropertyName: "didSucceed",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
			];
		}
	}
