<?php
	namespace CompatibilityLayer;

	/**
	 * Utility class for converting the global variable definitions in layout files into simple PHPDoc
	 * comment strings.
	 *
	 * E.g.
	 * global $headContents
	 * into
	 * \/** @var string $headContents *\/ (minus backslashes here for escaping)
	 */
	class LayoutVariableConverter{

		/**
		 * Fetch the number of globals defined via string matching.
		 */
		public static function getNumberOfGlobalsDefined(string $content): int{
			$totalCount = 0;
			preg_match_all(
				pattern: "/<\?php(.+?)\?>/ism",
				subject:$content,
				matches:$matches,
			);

			if (isset($matches[1])){
				foreach($matches[1] as $phpSourceMatch){
					// Find any global definitions
					preg_match_all(
						pattern: "/global \\$(.+?);/i",
						subject:$phpSourceMatch,
						matches:$globalVariableNameMatches
					);
					if (isset($globalVariableNameMatches[1])){
						$totalCount += count($globalVariableNameMatches[1]);
					}
				}
			}else{
				return 0;
			}

			return $totalCount;
		}

		/**
		 * Fetch the number of globals defined via string matching.
		 */
		public static function replaceGlobalVariablesWithPHPDocComment(string $content): string{
			return preg_replace_callback(
				pattern: "/<\?php(.+?)\?>/ism",
				callback:function($phpSourceCodeMatches){
					return preg_replace_callback(
						pattern: "/global \\$(.+?);/i",
						callback: function($matches){
							$variableName = $matches[1];
							return sprintf("/** @var mixed \$%s */", $variableName);
						},
						subject: $phpSourceCodeMatches[0],
					);
				},
				subject:$content,
			);
		}
	}