<?php

	namespace ActivityLogs;

	enum ActivityLogCategories: int
	{
		case PAGE_CREATION = 1;
		case CREATE_NEW_ACCOUNT = 2;
		/** @deprecated  */
		case BLOCK_IP = 3;
		case CREATE_ROLE = 4; // TODO: Log create role once the manager is made
		case UPDATE_ROLE_PERMISSIONS = 5; // TODO: Log updated role permissions once the manager is made
		case DELETE_PAGE = 6;
		/** @deprecated  */
		case REMOVE_IP_BLOCK = 7;
		/** @deprecated  */
		case UPDATE_BRUTE_FORCE_PROTECTION = 8;
		case DELETE_ROLE = 9; // TODO: Log deleted role once the manager is made
		case EDIT_ACCOUNT_INFORMATION = 10;
		case EDIT_PAGE = 11;
		/** @deprecated */
		case CHANGE_RMS_BUSINESS_ID = 12;
		/** @deprecated */
		case DELETE_RMS_CUSTOMER = 13;
		/** @deprecated */
		case UPDATE_INCLUSION_FILES = 14;
		case NEW_REDIRECT = 15;
		/** @deprecated  */
		case UPDATE_CORE_SETTINGS = 16;
		/** @deprecated */
		case CREATE_INCLUDE_FILE = 17;
		/** @deprecated */
		case CREATE_LAYOUT_FILE = 18;
		case SIGNED_IN = 19;
		case CHANGED_PASSWORD = 20;
		/** @deprecated */
		case UPDATE_COMPANY_DATA = 21;
		case POST_REVIEW = 22;
		case UPDATE_REVIEW = 23;
		case DELETE_REVIEW = 24;
		case EDIT_REDIRECT = 25;
		case DELETE_REDIRECT = 26;
		case CREATE_IMAGE_GALLERY = 27;
		case RENAME_IMAGE_GALLERY = 28;
		case DELETE_IMAGE_GALLERY = 29;
		case ADD_IMAGES_TO_GALLERY = 30;
		case REMOVE_IMAGES_FROM_GALLERY = 31;
		case RESTORE_PAGE_REVISION = 32; // TODO: Log restore page revision once it works
		case RESTORE_DELETED_PAGE = 33; // TODO: Log restore deleted page once it works
		/** @deprecated */
		case REPLACED_CONTENT = 34;
		case THEME_FILE_CHANGED = 35;
		case THEME_FILE_CREATED = 36;
		case THEME_FILE_DELETED = 37;
		case THEME_FOLDER_CREATED = 38;
		/** @deprecated */
		case THEME_FILE_SYSTEM_ITEM_RENAMED = 39;
		case COMPILE_SCSS = 40;
		case CONVERT_PAGE_TYPE = 41;
		case CLONE_PAGE = 42;
		case CREATE_ARTICLE_CATEGORY = 43;
		case RENAME_ARTICLE_CATEGORY = 44;
		case DELETE_ARTICLE_CATEGORY = 45;
		case CREATE_PROJECT_POST_TAG = 46;
		case RENAME_PROJECT_POST_TAG = 47;
		case DELETE_PROJECT_POST_TAG = 48;
		case LINK_PROJECT_TAG_TO_PAGE = 49;
		case REMOVE_PROJECT_TAG_FROM_PAGE = 50;
		case LINK_ARTICLE_CATEGORY_TO_PAGE = 51;
		case REMOVE_ARTICLE_CATEGORY_FROM_PAGE = 52;
		case UPDATE_COMPANY_INFORMATION = 53;
		case UPDATE_UPLIFT_SETTINGS = 54;
		case UPDATE_CONTENT_SETTINGS = 55;
		case EDIT_ROBOT_SETTINGS = 56;
		case CHANGE_ACCOUNT_DISABLE_STATUS = 57;
		case THEME_FOLDER_DELETED = 58;
		case THEME_FOLDER_CHANGED = 59;
		case EDIT_IMAGES_IN_GALLERY = 60;
		case CREATE_SITEMAP = 61;
		case EDIT_SITEMAP = 62;
		case DELETE_SITEMAP = 63;
		case MOVE_IMAGE = 64;
		case RENAME_IMAGE = 65;
		case RESIZE_IMAGE = 66;
		case CROP_IMAGE = 67;
		case UPLOAD_IMAGE = 68;
		case CLONE_IMAGE = 69;
		case DELETE_IMAGE = 70;
		case CREATE_IMAGE_DIRECTORY = 71;
		case RENAME_IMAGE_DIRECTORY = 72;
		case DELETE_IMAGE_DIRECTORY = 73;
		CASE MOVE_IMAGE_DIRECTORY = 74;
		CASE EDIT_SEARCH_CONSOLE_ACTIVE_SITE = 75;
		CASE RE_REGISTER_BUILD = 76;
		CASE SAVE_APACHE_CONFIG_FILE = 77;
		CASE LOGIN_TOKEN_FETCHED_VIA_REMOTE = 78;
		CASE LOGIN_WITH_TOKEN_VIA_REMOTE = 79;
		CASE UPLOADED_IPP_VIA_FORM = 80;
		CASE UPLOADED_IMAGE_VIA_FORM = 81;
		CASE FINALIZED_IPP_UPLOAD_VIA_FORM = 82;
		CASE EXTERNAL_SITE_IMPORTER_URL_FETCH = 83;
		CASE EXTERNAL_SITE_IMPORTER_BUILD_PAGE = 84;
		CASE REPLACED_CONTENT_VIA_FIND_REPLACE = 85;
		CASE DELETED_PAGE_RESTORED = 86;
		CASE IMPORTED_SENZU_SITE = 87;
		CASE NEW_PAGE_ATTRIBUTE = 88;
		CASE EDIT_PAGE_ATTRIBUTE = 89;
		CASE DELETE_PAGE_ATTRIBUTE = 90;
		CASE EDIT_OPT_OUT_INJECTABLES_SETTINGS = 91;
		CASE CHANGE_THEME = 92;

		const ACTION_VERBIAGE = [
			1 => "created a new page",
			2 => "create a new account",
			3 => "blocked an IP",
			4 => "created a new permission role",
			5 => "updated a role's permissions",
			6 => "deleted a page",
			7 => "removed a blocked IP",
			8 => "updated login security settings",
			9 => "deleted a role",
			10 => "edited an account's info",
			11 => "edited a page",
			12 => "changed the RMS business ID",
			13 => "deleted an RMS customer entry",
			14 => "updated an include file",
			15 => "added a page redirect",
			16 => "updated CMS settings",
			17 => "created an include file",
			18 => "created a layout file",
			19 => "signed in",
			20 => "changed an account password",
			21 => "updated company data",
			22 => "posted a review",
			23 => "edited a review",
			24 => "deleted a review",
			25 => "edited a redirect",
			26 => "deleted a redirect",
			27 => "created an image gallery",
			28 => "renamed an image gallery",
			29 => "deleted an image gallery",
			30 => "added images to a gallery",
			31 => "removed an image from a gallery",
			32 => "restored a page from a revision",
			33 => "restored a deleted page",
			34 => "found and replaced content on a page",
			35 => "edited a theme file",
			36 => "created a theme file",
			37 => "deleted a theme file",
			38 => "created a new theme directory",
			39 => "renamed a theme file or folder",
			40 => "compiled a SCSS file",
			41 => "converted a page to a new type",
			42 => "cloned a page",
			43 => "created an article category",
			44 => "renamed an article category",
			45 => "deleted an article category",
			46 => "created a project post tag",
			47 => "renamed a project post tag",
			48 => "deleted a project post tag",
			49 => "added a project tag to an IPP",
			50 => "removed a project tag from an IPP",
			51 => "added an article category to a blog post",
			52 => "removed an article category to a blog post",
			53 => "updated company information",
			54 => "updated Uplift settings",
			55 => "updated content settings",
			56 => "updated robot settings",
			57 => "changed an account disable status",
			58 => "deleted a theme directory",
			59 => "changed a theme directory",
			60 => "changed image positions in gallery",
			61 => "created new sitemap",
			62 => "edited sitemap",
			63 => "deleted sitemap",
			64 => "moved an image",
			65 => "renamed an image",
			66 => "resized an image",
			67 => "cropped an image",
			68 => "uploaded an image",
			69 => "cloned an image",
			70 => "deleted an image",
			71 => "created an image directory",
			72 => "renamed an image directory",
			73 => "deleted an image directory",
			74 => "moved an image directory",
			75 => "changed the active search console site",
			76 => "re-registered the build with the master control panel",
			77 => "edited Apache config file",
			78 => "had a login token generated via remote API",
			79 => "logged in via remote API request",
			80 => "uploaded an IPP via client IPP form",
			81 => "uploaded an image via client IPP form",
			82 => "completed IPP submission finalization process via client IPP form",
			83 => "fetched a URL via external site importer",
			84 => "built a page using the external site importer",
			85 => "used Find & Replace to replace content",
			86 => "restored a deleted page from edit archives",
			87 => "imported a website from Senzu",
			88 => "created a new page attribute",
			89 => "edited a page attribute",
			90 => "deleted a page attribute",
			91 => "edited system opt-out of front-end injectables",
			92 => "changed the active theme",
		];
	}