<?php

	namespace Accounts\Attributes;

	use Accounts\Account;
	use Nox\Router\AttributeResponse;
	use Nox\Router\Interfaces\RouteAttribute;

	/**
	 * Requires that no account be logged in
	 */
	#[\Attribute(\Attribute::TARGET_METHOD)]
	class RequireNoAccount implements RouteAttribute{

		public function __construct(
			public bool $rewriteRequestIfAccountPresent = true,
			public int $responseCode = 403,
			public ?string $newRoute = null,
		){}

		public function getAttributeResponse(): AttributeResponse
		{
			/** @var Account | null $currentUser */
			$currentUser = Account::getCurrentUser();

			if ($currentUser !== null) {
				if ($this->rewriteRequestIfAccountPresent) {
					return new AttributeResponse(
						isRouteUsable: false,
						responseCode: $this->responseCode,
						newRequestPath: $this->newRoute
					);
				}else{
					return new AttributeResponse(
						isRouteUsable: false,
					);
				}
			}else{
				return new AttributeResponse(
					isRouteUsable: true,
				);
			}
		}
	}