<?php

	namespace Accounts;

	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class AccountCookieSession extends ModelClass implements ModelInstance
	{
		public ?int $id = null;
		public int $userID;
		public string $cookie;
		public int $expires;

		/**
		 * Generate a token hash to use as a cookie value
		 */
		public static function generateTokenHash(string $salt): string{
			return hash("sha256", time() . $salt);
		}

		public static function getModel(): MySQLModelInterface{
			return new AccountsCookieSessionsModel();
		}

		public function __construct(){
			parent::__construct($this);
		}

	}