<?php
	namespace APIPublic;

	use Nox\Router\AttributeResponse;
	use Nox\Router\Interfaces\RouteAttribute;
	use Settings\Setting;
	use Settings\Settings;

	#[\Attribute(\Attribute::TARGET_METHOD)]
	class AuthorizeByAPIKey implements RouteAttribute {
		public function getAttributeResponse(): AttributeResponse{
			$httpHeaders = getallheaders();

			/** @var Setting $apiKey */
			$apiKey = Setting::fetch(Settings::UPLIFT_CONTROL_PANEL_API_KEY->value);

			if ($apiKey === null){
				return new AttributeResponse(
					isRouteUsable: false,
					responseCode: 500,
					newRequestPath: "/system-missing-api-key"
				);
			}

			foreach($httpHeaders as $headerName=>$headerValue){
				if (strtolower($headerName) === "uplift-api-key"){
					if ($apiKey->value === $headerValue){
						return new AttributeResponse(
							isRouteUsable: true,
						);
					}else{
						return new AttributeResponse(
							isRouteUsable: false,
							responseCode: 403,
							newRequestPath: "/bad-api-key"
						);
					}
				}
			}

			return new AttributeResponse(
				isRouteUsable: false,
				responseCode: 403,
				newRequestPath: "/missing-api-key"
			);
		}
	}