@Layout = "backend-basic.php"
@Head{
	<title>Manage User Accounts</title>
	<script defer src="/uplift-assets/js/_external/popper.js"></script>
	<script type="module" src="/uplift-assets/js/user-accounts/UserAccounts.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 mb-0">
									User Accounts
								</h2>
								<button type="button" class="btn btn-success" id="new-user-modal-trigger-button">
									<i class="bi bi-person-plus-fill"></i>
									<span>Create a User</span>
								</button>
							</div>
						</div>
						<div class="card-body">
							<div class="d-flex justify-content-end mb-3">
								<form id="user-search-form">
									<div class="input-group">
										<span class="input-group-text">
											<i class="bi bi-search"></i>
										</span>
										<input type="text" id="user-search" name="query" class="form-control" placeholder="Search user accounts">
									</div>
								</form>
							</div>
							<div id="users-rows-headers" class="users-columns">
								<div class="username">
									<strong>Username</strong>
								</div>
								<div class="name">
									<strong>Name</strong>
								</div>
								<div class="role">
									<strong>Role</strong>
								</div>
								<div class="last-activity">
									<strong>Last Activity</strong>
								</div>
								<div class="management-buttons"></div>
							</div>
							<div id="users-loader" class="text-center">
								<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
									<span class="visually-hidden">Loading...</span>
								</div>
							</div>
							<div id="users-rows-container"></div>
							<hr>
							<div class="d-flex justify-content-end">
								<?php include __DIR__ . "/../_partials/pagination.html" ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include_once __DIR__ . "/modals/new-user-modal.php" ?>
}
