<?php
	/** @var array{currentTheme: string, phoneNumbers: array, faxNumbers: array, themes: array, startingThemeNavigationDirectory: string, themeRootDirectory: string} $viewScope */

	use Accounts\Account;
	use Roles\PermissionCategories;
	use System\Themes;

	$account = Account::getCurrentUser();
?>
@Layout = "backend-page-editor.php"
@Head{
	<title>Theme File Manager</title>
	<script defer src="/uplift-assets/js/_external/popper.min.js"></script>
	<script defer src="/uplift-assets/js/_external/ace-editor/src-min-noconflict/ace.js"></script>
	<script type="module" src="/uplift-assets/js/editors/file-editor/FileEditor.js"></script>
}
@Body{
	<input type="hidden" id="current-theme-directory-path" value="<?= Themes::getCurrentThemeDirectory() ?>">
	<input type="hidden" id="has-image-manager-perms" value="<?= $account->hasPermission(PermissionCategories::MANAGE_IMAGES) ? "1" : "0" ?>">
	<div id="file-editor-main-container">
		<div id="theme-changing-modal" style="display:none;">
			<div class="d-flex align-items-center justify-content-center h-100">
				<h5>Changing themes...</h5>
			</div>
		</div>
		<div id="content-editor-options-bar">
			<section class="editor-toolbar-editor-buttons">
				<div class="editor-options-dropdown">
					<button type="button">
						<span>Themes</span>
					</button>
					<div class="dropdown">
						<?php foreach (Themes::getThemes() as $key => $theme) { ?>
							<button type="button" class="theme-selector-button" id="<?= $key ?>">
								<?= (Themes::getCurrentTheme() === $key) ? $theme . '<span class="small fst-italic text-muted"> - Active</span>' : $theme ?>
							</button>
						<?php } ?>
					</div>
				</div>
				<button type="button" id="open-image-manager-button">
					<span>Image Manager</span>
				</button>
				<div class="editor-options-dropdown">
					<button type="button">
						<span>PHP Variables</span>
					</button>
					<div class="dropdown">
						<div class="editor-options-dropdown">
							<button type="button">
								<span>Phone Numbers</span>
							</button>
							<div class="dropdown">
								<div class="d-flex editor-toolbar-dropdown-expansion">
									<?php
										foreach($viewScope['phoneNumbers'] as $index=>$number){
											?>
											<button type="button" class="company-phone-php-var-button" data-index="<?= $index ?>">
												<span><?= $number; ?></span>
											</button>
											<button type="button" class="pure-company-phone-php-var-button" data-index="<?= $index ?>">
												<i class="bi bi-123"></i>
												<span>Pure</span>
											</button>
											<?php
										}
									?>
								</div>
							</div>
						</div>
						<div class="editor-options-dropdown">
							<button type="button">
								<span>Fax Numbers</span>
							</button>
							<div class="dropdown">
								<?php
									foreach($viewScope['faxNumbers'] as $index=>$number){
										?>
										<button type="button" class="company-fax-php-var-button" data-index="<?= $index ?>">
											<span><?= $number; ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<button type="button" class="" id="company-name-php-var-button">
							<span>Company Name</span>
						</button>
						<button type="button" class="" id="company-street-php-var-button">
							<span>Company Street</span>
						</button>
						<button type="button" class="" id="company-postal-php-var-button">
							<span>Company Postal</span>
						</button>
						<button type="button" class="" id="company-city-php-var-button">
							<span>Company City</span>
						</button>
						<button type="button" class="" id="company-state-php-var-button">
							<span>Company State</span>
						</button>
						<button type="button" class="" id="company-logo-php-var-button">
							<span>Company Logo</span>
						</button>
						<button type="button" class="" id="map-key-php-var-button">
							<span>Map Key</span>
						</button>
					</div>
				</div>
			</section>
			<section class="editor-toolbar-page-buttons">
				<button style="display:none;" id="layout-sections-button" class="btn btn-info btn-sm" type="button">
					<i class="bi bi-columns"></i>
					<span>Layout Sections</span>
				</button>
				<button style="display:none;" id="save-file-button" class="btn btn-control btn-sm" type="submit" form="file-editor-form">
					<span>Save File (Ctrl + s)</span>
				</button>
			</section>
		</div>
		<div id="editor-warnings" class="bg-warning text-dark p-2d-none"></div>
		<div id="directory-location-container">
			<form id="directory-location-form">
				<input readonly autocomplete="off" class="form-control" id="directory-location-input" name="directory-location" value="<?= $viewScope['startingThemeNavigationDirectory'] ?>">
				<input type="hidden" id="theme-root-directory" value="<?= $viewScope['themeRootDirectory'] ?>">
			</form>
		</div>
		<div id="content-editor-page-container">
			<aside id="content-editor-sidebar">
				<section>
					<form id="directory-filter-form">
						<input id="directory-filter" type="text" class="form-control form-control-sm" placeholder="Filter entries...">
					</form>
				</section>
				<section id="content-editor-page-navigation-column">
					<div id="content-editor-sidebar-overlays-container" class="p-2">
						<div id="import-drag-over-window" class="sidebar-overlay" style="display:none;">
							<div>
								<div class="mb-3">
									<svg xmlns="http://www.w3.org/2000/svg" width="1rem" height="1rem" fill="currentColor" class="bi bi-cloud-upload-fill" viewBox="0 0 16 16">
										<path fill-rule="evenodd" d="M8 0a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 4.095 0 5.555 0 7.318 0 9.366 1.708 11 3.781 11H7.5V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11h4.188C14.502 11 16 9.57 16 7.773c0-1.636-1.242-2.969-2.834-3.194C12.923 1.999 10.69 0 8 0zm-.5 14.5V11h1v3.5a.5.5 0 0 1-1 0z"/>
									</svg>
								</div>
								<div><strong>Drop to import</strong></div>
							</div>
						</div>
						<div id="importing-status-overlay" class="sidebar-overlay" style="display:none;">
							<div>
								<div class="mb-3">
									<div class="spinner-border text-white" style="width:2rem;height:2rem;"></div>
								</div>
								<div id="import-status-read-status">
									<strong>Uploading <span id="drag-upload-current">0</span> of <span id="drag-upload-max">0</span></strong>
								</div>
								<div id="import-status-upload-status">
									<strong>Saving to the CMS...</strong>
								</div>
							</div>
						</div>
						<div id="compiling-scss-overlay" class="sidebar-overlay" style="display:none;">
							<div>
								<div class="mb-3">
									<div class="spinner-border"></div>
								</div>
								<div>
									<strong>Compiling SCSS -&gt; CSS</strong>
								</div>
							</div>
						</div>
						<div id="sidebar-loading-overlay" class="loading-sidebar-overlay" style="display:none;">
							<div>
								<div class="mb-3">
									<div class="spinner-grow text-primary" style="width:4rem; height:4rem;"></div>
								</div>
								<div>
									<strong>Loading...</strong>
								</div>
							</div>
						</div>
						<div>
							<button type="button" id="back-button-directory-listing">
								<svg xmlns="http://www.w3.org/2000/svg" width="1rem" height="1rem" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
								</svg>
								<span>Back</span>
							</button>
						</div>
						<div id="directory-listing"></div>
					</div>
				</section>
			</aside>
			<section id="content-editor-container" class="position-relative" style="display:none;">
				<div id="editor-loading" style="display:none;">
					<div class="h-100 d-flex align-items-center justify-content-center">
						<h5>Loading file...</h5>
					</div>
				</div>
				<section id="content-editor-tabs-container"></section>
				<form id="file-editor-form" class="h-100">
					<div class="page-window editor-window h-100" id="file-content" ace-lang="php"></div>
				</form>
			</section>
		</div>
	</div>

	<?php include __DIR__ . "/../_partials/image-manager/_main.php"; ?>
	<?php include __DIR__ . "/modals/new-directory.html"; ?>
	<?php include __DIR__ . "/modals/new-file.html"; ?>
	<?php include __DIR__ . "/modals/rename-file.html"; ?>
	<?php include __DIR__ . "/modals/rename-directory.html"; ?>
}
