<?php
	/** @var array $viewScope */

	use Settings\Settings;

	$optOutOfLightbox = isset($viewScope[Settings::OPT_OUT_LIGHTBOX_INJECTION->name]) && $viewScope[Settings::OPT_OUT_LIGHTBOX_INJECTION->name] == "1";
?>
<form id="injections-form" class="card rounded shadow mb-4">
	<div class="card-header">
		<h4 class="mb-0">
			Front-End Injections
		</h4>
	</div>
	<div class="card-body">
		<div>
			<p>
				When Uplift optionally injects certain characteristics or resources to the global front-end, you can opt-out of those injections here.
			</p>
		</div>
		<div>
			<div class="form-check form-switch">
				<input <?= $optOutOfLightbox ? "checked" : ""  ?> class="form-check-input" type="checkbox" role="switch" id="opt-out-lightbox-check-input" name="opt-out-lightbox">
				<label class="form-check-label" for="opt-out-lightbox-check-input">Opt out of Lightbox injections</label>
			</div>
		</div>
	</div>
	<div class="card-footer">
		<div class="text-end">
			<button type="submit" class="btn btn-success">
				<i class="bi bi-check-circle-fill"></i>
				<span>Save Injection Settings</span>
			</button>
		</div>
	</div>
</form>