<?php
	/** @var array $viewScope */

	use Settings\Settings;
?>
<form id="content-settings-form" class="card rounded shadow mb-4">
	<div class="card-header">
		<h4 class="mb-0">
			Content Settings
		</h4>
	</div>
	<div class="card-body">
		<div>
			<label for="no-reviews-message">Reviews Message</label>
			<input id="no-reviews-message" autocomplete="off" type="text" name="noReviewsMessage" class="form-control" value="<?= $viewScope[Settings::NO_REVIEWS_MESSAGE->name] ?>">
			<small>The message that is displayed when there are no reviews to pull for a shortcode and the empty message parameter is true. Accepts HTML and is <strong>not</strong> sanitized.</small>
		</div>
	</div>
	<div class="card-footer">
		<div class="text-end">
			<button type="submit" class="btn btn-success">
				<i class="bi bi-check-circle-fill"></i>
				<span>Save Content Settings</span>
			</button>
		</div>
	</div>
</form>