<?php
	/** @var array $viewScope */

	use Settings\CustomSettings;
	use Settings\CustomSettingService;
	use Settings\Settings;

	$additionalAddresses = CustomSettingService::getAllCustomSettings(CustomSettings::ADDITIONAL_ADDRESS);
?>
<textarea style="display:none;" id="phone-numbers-initial-load-json"><?= $viewScope[Settings::COMPANY_PHONE_NUMBERS->name] ?></textarea>
<textarea style="display:none;" id="fax-numbers-initial-load-json"><?= $viewScope[Settings::COMPANY_FAX_NUMBERS->name] ?></textarea>
<textarea style="display:none;" id="additional-addresses-initial-load-json"><?= json_encode($additionalAddresses) ?></textarea>
<form id="company-information-form" class="card rounded shadow mb-4">
	<div class="card-header">
		<h4 class="mb-0">
			Company Information
		</h4>
	</div>
	<div class="card-body">
		<div class="container-fluid">
			<div class="row">
				<div class="col-6">
					<div class="mb-2">
						<label for="schema-type">Schema Type</label>
						<div class="input-group">
							<div class="input-group-text"><i class="bi bi-card-list"></i></div>
							<input id="schema-type" list="settings-schema-list" autocomplete="off" type="text" name="schemaType" class="form-control" value="<?= $viewScope[Settings::SCHEMA_TYPE->name] ?>">
						</div>
						<datalist id="settings-schema-list">
							<?php include __DIR__ . "/../_partials/schema-data-list.html" ?>
						</datalist>
					</div>
					<div class="mb-2">
						<label for="company-accelo-id-input">Accelo Company ID</label>
						<div class="input-group">
							<div class="input-group-text"><i class="bi bi-person-lines-fill"></i></div>
							<input id="company-accelo-id-input" autocomplete="off" type="text" name="company-accelo-id" class="form-control" value="<?= $viewScope[Settings::ACCELO_COMPANY_ID->name] ?>">
						</div>
					</div>
					<div class="mb-2">
						<label for="company-name">Company Name</label>
						<div class="input-group">
							<div class="input-group-text"><i class="bi bi-textarea-t"></i></div>
							<input id="company-name" autocomplete="off" type="text" name="companyName" class="form-control" value="<?= $viewScope[Settings::COMPANY_NAME->name] ?>">
						</div>
					</div>
					<div class="mb-2">
						<label for="company-street">Company Street</label>
						<div class="input-group">
							<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
							<input id="company-street" autocomplete="off" type="text" name="companyStreet" class="form-control" value="<?= $viewScope[Settings::COMPANY_STREET->name] ?>">
						</div>
					</div>
					<div class="mb-2">
						<label for="company-city">Company City</label>
						<div class="input-group">
							<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
							<input id="company-city" autocomplete="off" type="text" name="companyCity" class="form-control" value="<?= $viewScope[Settings::COMPANY_CITY->name] ?>">
						</div>
					</div>
					<div class="row mb-2">
						<div class="col-6">
							<div>
								<label for="company-state">Company State (abbr.)</label>
								<div class="input-group">
									<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
									<input id="company-state" autocomplete="off" type="text" name="companyState" class="form-control" value="<?= $viewScope[Settings::COMPANY_STATE->name] ?>">
								</div>
							</div>
						</div>
						<div class="col-6">
							<div>
								<label for="company-postal">Company Postal</label>
								<div class="input-group">
									<div class="input-group-text"><i class="bi bi-geo-alt-fill"></i></div>
									<input id="company-postal" autocomplete="off" type="text" name="companyPostal" class="form-control" value="<?= $viewScope[Settings::COMPANY_POSTAL->name] ?>">
								</div>
							</div>
						</div>
					</div>
					<div class="row align-items-center">
						<div class="col-6">
							<div>
								<span>Company Logo</span>
								<div class="d-flex align-items-center">
									<img
										width="70"
										height="70"
										class="border me-3"
										id="logo-preview"
										alt=""
										src="<?= $viewScope[Settings::COMPANY_LOGO->name] ?>"
									>
									<label for="company-logo-input" class="btn btn-primary btn-sm set-preview">
										<i class="bi bi-upload"></i>
										<span>Upload Image</span>
									</label>
									<input
										id="company-logo-input"
										class="d-none"
										type="file"
										data-max-size-in-mb="1"
										data-error-id="image-error"
										data-preview-id="logo-preview"
										name="companyLogo"
									/>
								</div>
							</div>
						</div>
						<div class="col-6">
							<div>
								<span>Company Favicon</span>
								<div class="d-flex align-items-center">
									<img
										width="32"
										height="32"
										class="border me-3"
										id="favicon-preview"
										alt=""
										src="<?= $viewScope[Settings::COMPANY_FAVICON->name] ?>"
									>
									<label for="company-favicon-input" class="btn btn-primary btn-sm set-preview">
										<i class="bi bi-upload"></i>
										<span>Upload Image</span>
									</label>
									<input id="company-favicon-input" class="d-none" type="file" data-max-size-in-mb="0.05" data-error-id="image-error" data-preview-id="favicon-preview" name="companyFavicon">
								</div>
							</div>
						</div>
						<div class="my-2 p-2 bg-danger text-white" id="image-error" style="display: none;">The file size for this field restricts uploads to be under 1M.</div>
					</div>
				</div>
				<div class="col-6">
					<div class="mb-5">
						<div id="phone-numbers-headline-container" class="d-flex justify-content-between align-items-center">
							<div>
								<h5 class="mb-0">Phone Numbers</h5>
							</div>
							<div>
								<button type="button" class="btn btn-primary btn-sm" id="add-phone-number-button">
									<i class="bi bi-plus-circle-fill"></i>
									<span>Phone Number</span>
								</button>
							</div>
						</div>
						<div class="my-2" id="no-phone-numbers-message">
							<em>No phone numbers</em>
						</div>
						<div id="phone-numbers"></div>
					</div>
					<div>
						<div id="fax-numbers-headline-container" class="d-flex justify-content-between align-items-center">
							<div>
								<h5 class="mb-0">Fax Numbers</h5>
							</div>
							<div>
								<button type="button" class="btn btn-primary btn-sm" id="add-fax-number-button">
									<i class="bi bi-plus-circle-fill"></i>
									<span>Fax Number</span>
								</button>
							</div>
						</div>
						<div class="my-2" id="no-fax-numbers-message">
							<em>No fax numbers</em>
						</div>
						<div id="fax-numbers"></div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<hr>
					<div>
						<div id="additional-addresses"></div>
						<button id="add-address-button" type="button" class="btn btn-primary btn-sm">
							<i class="bi bi-plus-circle-fill"></i>
							<span>Additional Address</span>
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card-footer">
		<div class="text-end">
			<button type="submit" class="btn btn-success">
				<i class="bi bi-check-circle-fill"></i>
				<span>Save Company Information</span>
			</button>
		</div>
	</div>
</form>