<?php
	/** @var array $viewScope */

	use Settings\Setting;
	use Settings\Settings;
?>
<div class="card">
	<div class="card-header">
		<h4 class="mb-0">Build Registration Information</h4>
	</div>
	<div class="card-body">
		<p>
			Below is information regarding the build's assigned UUID and API key from the Uplift Control Panel. If updating fails due to a permission denied error - or if this information is blank - attempting to re-register the build can resolve these issues.
		</p>
		<div class="mb-3">
			<div>
				<strong>UUID: </strong><span id="build-uuid"><?= Setting::getSettingValue(Settings::BUILD_UUID->value) ?></span>
			</div>
			<div>
				<strong>API Key: </strong><span id="build-api-key"><?= Setting::getSettingValue(Settings::UPLIFT_CONTROL_PANEL_API_KEY->value) ?></span>
			</div>
		</div>
		<div>
			<button type="button" id="reregister-build-button" class="btn btn-primary btn-sm">
				<i class="bi bi-r-square-fill"></i>
				<span>Re-Register Build</span>
			</button>
		</div>
		<div id="register-success-container" class="mt-3 alert alert-success" style="display:none;">Build successfully re-registered. A new API key and new UUID has been assigned.</div>
	</div>
</div>