<?php

?>
<div id="recent-projects-modal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<form id="recent-projects-form" class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Add recent projects</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<label for="recent-projects-num-projects-input">Number of projects</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="recent-projects-num-projects-input" value="2" type="text" class="form-control" name="num-recent-projects">
					</div>
				</div>
				<div class="mb-3">
					<label for="recent-projects-num-columns-input">Number of columns</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="recent-projects-num-columns-input" value="1" type="text" class="form-control" name="recent-projects-num-columns">
					</div>
				</div>
				<div class="mb-3">
					<div class="mb-2">
						<span>Optionally, you can include only projects with specific project tags. Selecting none will include all projects.</span>
					</div>
					<div id="recent-projects-tags-container"></div>
					<div id="recent-projects-tags-loader">
						<div class="spinner-border text-primary"></div>
					</div>
					<div id="recent-projects-no-tags-categories" style="display:none;">
						<span><em>The system has no project tags - you cannot narrow down to selected tags right now.</em></span>
					</div>
				</div>
				<div class="mb-3">
					<div class="mb-2">
						<span>Autofill projects if the selected project tag doesn't have enough projects to satisfy <em>Number of projects</em>?</span>
					</div>
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="" id="recent-projects-autofill">
						<label class="form-check-label" for="recent-projects-autofill">
							Autofill
						</label>
					</div>
				</div>
				<div class="submit-error bg-danger text-danger-contrast p-2 my-2" style="display:none;"></div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">
					<i class="bi bi-file-arrow-up-fill"></i>
					<span>Insert</span>
				</button>
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<i class="bi bi-x-circle-fill"></i>
					<span>Cancel</span>
				</button>
			</div>
		</form>
	</div>
</div>
