<?php
	/** @var PageType[] $pageTypes */

	use Page\PageType;

?>
<div id="new-page-modal" class="modal" role="dialog">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<form id="new-page-form">
				<div class="modal-header">
					<h5 class="modal-title">Create a page</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div class="mb-3">
						<label for="new-page-type">New page type</label>
						<select id="new-page-type" name="page-type" class="form-control">
							<option value="-1">- Select a page type -</option>
							<?php
								foreach($pageTypes as $pageType){
									?>
									<option value="<?= $pageType->name ?>"><?= $pageType->name ?>
									<?php
								}
							?>
						</select>
					</div>
					<div>
						<label for="new-page-name-input">Page name</label>
						<input type="text" class="form-control" name="page-name" id="new-page-name-input">
						<small>Page names must be unique</small>
					</div>
				<div class="submit-error my-2 p-2 bg-danger text-white" style="display:none;"></div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="submit-new-page-form" class="btn btn-success" >
						<i class="bi bi-plus-circle-fill"></i>
						<span>Create</span>
					</button>
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
						<span>Cancel</span>
					</button>
				</div>
			</form>
		</div>
	</div>
</div>
