<?php
	use ProjectPostTag\ProjectPostTag;
?>
<div id="ipp-reel-modal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<form id="ipp-reel-form" class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Add an IPP Reel</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<label for="ipp-reel-projects-per-page">Projects per page</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="ipp-reel-projects-per-page" value="10" type="text" class="form-control form-control-sm" name="ipp-reel-projects-per-page" placeholder="How many projects to show per page">
					</div>
				</div>
				<div class="mb-3">
					<label for="ipp-reel-num-columns">Number of columns</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="ipp-reel-num-columns" value="1" type="text" class="form-control form-control-sm" name="ipp-reel-num-columns" placeholder="How many pro to put the projects in">
					</div>
				</div>
				<?php
					if (!empty($allProjectTags)){
						?>
						<div class="mb-3">
							<label>Which project tags should be included? Leave blank to include all.</label>
							<div>
								<?php
									foreach($allProjectTags as $projectPostTag){
										$tagID = $projectPostTag->id;
										$tagLabel = $projectPostTag->label;
										?>
										<button type="button" data-tag-id="<?= $tagID ?>" class="ipp-reel-tag-include-button btn-sm btn btn-outline-primary">
											<i class="bi bi-tag-fill"></i>
											<span><?= $tagLabel ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<?php
					}
				?>
				<?php
					if (!empty($allProjectTags)){
						?>
						<div class="mb-3">
							<label>Optionally, you can exclude project tags instead of specify only ones you want to include.</label>
							<div>
								<?php
									foreach($allProjectTags as $projectPostTag){
										$tagID = $projectPostTag->id;
										$tagLabel = $projectPostTag->label;
										?>
										<button type="button" data-tag-id="<?= $tagID ?>" class="ipp-reel-tag-exclude-button btn btn-sm btn-outline-danger">
											<i class="bi bi-tag-fill"></i>
											<span><?= $tagLabel ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<?php
					}
				?>
				<div style="display:none;" class="submit-error bg-danger text-danger-contrast p-2 my-2"></div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">
					<i class="bi bi-file-arrow-up-fill"></i>
					<span>Insert</span>
				</button>
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<i class="bi bi-x-circle-fill"></i>
					<span>Cancel</span>
				</button>
			</div>
		</form>
	</div>
</div>
