<?php
	/** @var array $viewScope */
	/** @var Account $account */

	use Accounts\Account;
	use Page\Page;
	use Page\PageType;
	use PageEditor\PageEditorViewType;
	use ProjectPostTag\ProjectPostTag;
	use Roles\PermissionCategories;

	/** @var PageEditorViewType $viewType */
	$viewType = $viewScope['viewingType'];
	$account = Account::getCurrentUser();

	/** @var array $phoneNumbers */
	$phoneNumbers = $viewScope['phoneNumbers'];

	/** @var array $faxNumbers */
	$faxNumbers = $viewScope['faxNumbers'];

	/** @var array $articleCategories */
	$articleCategories = $viewScope['articleCategories'];

	/** @var ProjectPostTag[] $allProjectTags These are the system tags and not just the ones assigned to this page */
	$allProjectTags = $viewScope['projectPostTags'];

	/** @var Page $page */
	$page = $viewScope['page'];

	$pageTypes = PageType::cases();
	sort($pageTypes);
?>
@Layout = "backend-page-editor.php"
@Head{
	<?php
		if ($viewType === PageEditorViewType::STANDARD){
			?>
			<title>Page Editor</title>
			<?php
		}elseif ($viewType === PageEditorViewType::REVISION){
				?>
				<title>Revision Viewer</title>
				<?php
		}
	?>
	<script defer src="/uplift-assets/js/_external/ace-editor/src-min-noconflict/ace.js"></script>
	<script defer src="/uplift-assets/js/_external/popper.min.js"></script>
	<script type="module" src="/uplift-assets/js/editors/page-editor/PageEditor.js"></script>
}
@Body{
	<input type="hidden" id="has-image-manager-perms" value="<?= $account->hasPermission(PermissionCategories::MANAGE_IMAGES) ? 1 : 0 ?>">
	<input type="hidden" id="page-editor-viewing-type" value="<?= $viewType->name ?>">
	<cms-editor-container>
		<div id="content-editor-options-bar">
			<section class="editor-toolbar-editor-buttons">
				<div id="editor-file-button-container" class="editor-options-dropdown">
					<button type="button">
						<span>File</span>
					</button>
					<div class="dropdown">
						<?php
							if($account->hasPermission(PermissionCategories::VIEW_PAGE_HISTORY)) {
								?>
								<a style="display:none;" id="page-revision-history-button" href="">Revision & History Manager</a>
								<?php
							}
						?>
						<button id="convert-page-button" style="display:none;" data-bs-toggle="modal" data-bs-target="#convert-page-type-modal" type="button">
							<span>Convert Page Type</span>
						</button>
						<button id="clone-page-button" style="display:none;" data-bs-toggle="modal" data-bs-target="#clone-page-modal" type="button">
							<span>Clone Page</span>
						</button>
						<button id="delete-page-button" style="display:none;" data-bs-toggle="modal" data-bs-target="#delete-page-modal" type="button">
							<span>Delete Page</span>
						</button>
					</div>
				</div>
				<?php
					if($account->hasPermission(PermissionCategories::MANAGE_IMAGES)) {
						?>
						<button type="button" data-set-image-manage-target="#page-content" id="upload-insert-image-button">
							<span>Image Manager</span>
						</button>
						<?php
					}
				?>
				<button style="display:none;" type="button" id="insert-gallery-button">
					<span>Insert Gallery</span>
				</button>
				<?php
					// If new tools are added to this button, add the perms to this
					if($account->hasAnyPermission([PermissionCategories::SEARCH_AND_REPLACE, PermissionCategories::VIEW_PAGE_HISTORY])) {
						?>
						<div id="tools-toolbar-container" class="editor-options-dropdown">
							<button type="button">
								<span>Tools</span>
							</button>
							<div class="dropdown">
								<?php
									if($account->hasPermission(PermissionCategories::SEARCH_AND_REPLACE)) {
										?>
										<a href="/uplift/find-and-replace">Find & Replace</a>
										<?php
									}
								?>
								<?php
									if($account->hasPermission(PermissionCategories::VIEW_PAGE_HISTORY)) {
										?>
										<a href="/uplift/deleted-page-restoration">Restore Deleted Page</a>
										<?php
									}
								?>
								<?php
									if($account->hasPermission(PermissionCategories::MANAGE_PAGE_ATTRIBUTES)) {
										?>
										<a href="/uplift/page-attributes">Manage Page Attributes</a>
										<?php
									}
								?>
							</div>
						</div>
						<?php
					}
				?>
				<div style="display:none;" id="editor-shortcodes-toolbar-button" class="editor-options-dropdown">
					<button type="button">
						<span>Shortcodes</span>
					</button>
					<div class="dropdown">
						<div class="editor-options-dropdown">
							<button type="button" id="phone-number-shortcode-button">
								<span>Phone Numbers</span>
							</button>
							<div class="dropdown">
								<div class="d-flex editor-toolbar-dropdown-expansion">
									<?php
										foreach($phoneNumbers as $index=>$number){
											?>
											<button type="button" class="company-phone-number-shortcode-button" number-index="<?= $index + 1; ?>">
												<span><?= $number; ?></span>
											</button>
											<button type="button" class="pure-company-phone-shortcode-button" number-index="<?= $index + 1 ?>">
												<i class="bi bi-123"></i>
												<span>Pure</span>
											</button>
											<?php
										}
									?>
								</div>
							</div>
						</div>
						<div class="editor-options-dropdown">
							<button type="button" id="fax-number-shortcode-button">
								<span>Fax Numbers</span>
							</button>
							<div class="dropdown">
								<?php
									foreach($faxNumbers as $index=>$number){
										?>
										<button type="button" class="shortcode-button" number-index="<?= $index + 1; ?>">
											<span><?= $number; ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<button type="button" class="shortcode-button" id="page-city-shortcode-button">
							<span>Page City</span>
						</button>
						<button type="button" class="shortcode-button" id="page-state-shortcode-button">
							<span>Page State</span>
						</button>
						<button type="button" class="shortcode-button" id="company-name-shortcode-button">
							<span>Company Name</span>
						</button>
						<button type="button" class="shortcode-button" id="company-street-shortcode-button">
							<span>Company Street</span>
						</button>
						<button type="button" class="shortcode-button" id="company-postal-shortcode-button">
							<span>Company Postal</span>
						</button>
						<button type="button" class="shortcode-button" id="company-city-shortcode-button">
							<span>Company City</span>
						</button>
						<button type="button" class="shortcode-button" id="company-state-shortcode-button">
							<span>Company State</span>
						</button>
						<button type="button" class="shortcode-button" id="company-logo-shortcode-button">
							<span>Company Logo</span>
						</button>
						<button type="button" class="shortcode-button" id="article-reel-shortcode-button">
							<span>Blog Reel</span>
						</button>
						<button type="button" class="shortcode-button" id="ipp-reel-shortcode-button">
							<span>IPP Reel</span>
						</button>
						<button type="button" class="shortcode-button" id="reviews-shortcode-button">
							<span>Reviews</span>
						</button>
						<button type="button" class="shortcode-button" id="recent-articles-shortcode-button">
							<span>Recent Articles</span>
						</button>
						<button type="button" class="shortcode-button" id="recent-projects-shortcode-button">
							<span>Recent Projects</span>
						</button>
						<button type="button" class="shortcode-button" id="get-pages-shortcode-button">
							<span>Get Pages</span>
						</button>
					</div>
				</div>
			</section>
			<section style="display:none;" id="editor-page-buttons-toolbar" class="editor-toolbar-page-buttons">
				<a id="view-page-external-link-button" href="#" class="btn btn-secondary btn-sm mr-2">
					<i class="bi bi-box-arrow-up-right"></i>
					<span>View Page</span>
				</a>
				<button class="btn btn-success btn-sm" type="submit" form="page-edit-form">
					<i class="bi bi-save-fill"></i>
					<span>Save (Ctrl + S)</span>
				</button>
			</section>
			<section style="display:none;" id="editor-revision-buttons-toolbar" class="editor-toolbar-page-buttons">
				<button class="btn btn-success btn-sm" type="submit" id="restore-revision-button">
					<i class="bi bi-bezier"></i>
					<span>Restore this Revision</span>
				</button>
			</section>
		</div>
		<div id="editor-warnings" class="bg-warning text-dark p-2d-none"></div>
		<div id="content-editor-page-container">
			<aside id="content-editor-sidebar">
				<section id="content-editor-page-navigation-column">
					<section id="pages-categories-loader">
						<div class="spinner-border text-primary"></div>
					</section>
					<section id="pages-categories-main" style="display:none;">
						<div class="page-types-title-container">
							<h4>Page Types</h4>
						</div>
						<div class="category-buttons-container">
							<?php
								if($account->hasPermission(PermissionCategories::MANAGE_BLOG_PAGES)) {
									?>
									<button type="button" data-page-enum="Blog" class="page-type-enum-button">
										<span>
											<span class="icon-container">
												<i class="bi bi-file-break-fill"></i>
											</span>
											<span class="text-container">
												<span class="label">Blog Pages</span>
												<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
											</span>
										</span>
									</button>
									<?php
								}
								if($account->hasPermission(PermissionCategories::MANAGE_CITY_PAGES)) {
									?>
									<button type="button" data-page-enum="City" class="page-type-enum-button">
											<span>
												<span class="icon-container">
													<i class="bi bi-file-break-fill"></i>
												</span>
												<span class="text-container">
													<span class="label">City Pages</span>
													<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
												</span>
											</span>
									</button>
									<?php
								}
								if($account->hasPermission(PermissionCategories::MANAGE_GENERAL_PAGES)) {
									?>
									<button type="button" data-page-enum="General" class="page-type-enum-button">
										<span>
											<span class="icon-container">
												<i class="bi bi-file-break-fill"></i>
											</span>
											<span class="text-container">
												<span class="label">General Pages</span>
												<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
											</span>
										</span>
									</button>
									<?php
								}
								if($account->hasPermission(PermissionCategories::MANAGE_PROJECT_PAGES)) {
									?>
									<button type="button" data-page-enum="Project" class="page-type-enum-button">
										<span>
											<span class="icon-container">
												<i class="bi bi-file-break-fill"></i>
											</span>
											<span class="text-container">
												<span class="label">Project Pages</span>
												<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
											</span>
										</span>
									</button>
									<?php
								}
								if($account->hasPermission(PermissionCategories::MANAGE_SERVICE_PAGES)) {
									?>
									<button type="button" data-page-enum="Service" class="page-type-enum-button">
										<span>
											<span class="icon-container">
												<i class="bi bi-file-break-fill"></i>
											</span>
											<span class="text-container">
												<span class="label">Service Pages</span>
												<span class="num-pages-container"><span class="num-pages">0</span> Pages</span>
											</span>
										</span>
									</button>
									<?php
								}
							?>
						</div>
					</section>
					<page-categories-sidebar style="display:none;">
						<section id="page-type-title-container">
							<h4>
								<span class="page-type-title"></span>
								<span>Pages</span>
							</h4>
						</section>
						<section id="sidebar-buttons-container">
							<button type="button" id="page-category-back-button">
								<i class="bi bi-arrow-left-circle-fill"></i>
								<span>Back</span>
							</button>
							<button type="button" id="page-category-new-page-button">
								<i class="bi bi-file-earmark-plus-fill"></i>
								<span>New Page</span>
							</button>
						</section>
						<section id="page-name-search-container">
							<form id="page-name-search-form">
								<input id="page-name-search" type="text" class="form-control form-control-sm" placeholder="Filter by page name">
							</form>
						</section>
						<section id="page-lists-container">
							<?php
								foreach($pageTypes as $case){
									?>
									<section style="display:none;" class="page-list" data-page-category="<?= $case->name ?>"></section>
									<?php
								}
							?>
						</section>
					</page-categories-sidebar>
				</section>
			</aside>
			<section style="display:none;" id="content-editor-loading-container">
				<div class="spinner-grow text-primary" role="status">
					<span class="visually-hidden">Loading...</span>
				</div>
			</section>
			<section style="display:none;" id="content-editor-container">
				<section id="content-editor-tabs-container">
					<button data-window="body" type="button" class="editor-tab selected">
						<span>
							<i class="bi bi-paragraph"></i>
							<span>Body</span>
						</span>
						<span style="display:none;" class="unsaved-changes">*</span>
						<div style="display:none;" class="saving-spinner spinner-border" role="status">
							<span class="visually-hidden">Loading...</span>
						</div>
					</button>
					<button data-window="head" type="button" class="editor-tab">
						<span>
							<i class="bi bi-card-heading"></i>
							<span>Head</span>
						</span>
						<span style="display:none;" class="unsaved-changes">*</span>
						<div style="display:none;" class="saving-spinner spinner-border" role="status">
							<span class="visually-hidden">Loading...</span>
						</div>
					</button>
					<button data-window="data" type="button" class="editor-tab">
						<span>
							<i class="bi bi-diagram-3-fill"></i>
							<span>Page Data</span>
						</span>
						<span style="display:none;" class="unsaved-changes">*</span>
						<div style="display:none;" class="saving-spinner spinner-border" role="status">
							<span class="visually-hidden">Loading...</span>
						</div>
					</button>
				</section>
				<form id="page-edit-form" class="h-100">
					<div class="page-window editor-window h-100" id="page-content" ace-lang="html"></div>
					<div class="page-window editor-window h-100" id="page-sections-content-container" style="display: none;"></div>
					<div class="page-window editor-window h-100" id="page-head" ace-lang="html" style="display:none;" ></div>
					<div class="page-window h-100" id="page-data" style="display:none;">
						<?php include __DIR__ . "/_page-data.php"; ?>
					</div>
				</form>
			</section>
		</div>
	</cms-editor-container>

	<!-- Image manager and modals -->
	<?php
		include __DIR__ . "/../_partials/image-manager/_main.php";
		if ($viewType === PageEditorViewType::STANDARD) {
			include __DIR__ . "/modals/new-page.php";
			include __DIR__ . "/modals/blog-reel.php";
			include __DIR__ . "/modals/convert-page-type.php";
			include __DIR__ . "/modals/delete-page.html";
			include __DIR__ . "/modals/clone-page.html";
			include __DIR__ . "/modals/recent-projects.php";
			include __DIR__ . "/modals/new-blog-category.html";
			include __DIR__ . "/modals/rename-blog-category.html";
			include __DIR__ . "/modals/rename-project-tag.html";
			include __DIR__ . "/modals/ipp-reel.php";
			include __DIR__ . "/modals/recent-articles.php";
			include __DIR__ . "/modals/insert-gallery-modal.html";
			include __DIR__ . "/modals/blog-category-management.php";
			include __DIR__ . "/modals/project-tags-management.php";
			include __DIR__ . "/modals/add-attribute.php";
			include __DIR__ . "/modals/get-pages.php";
		}
	?>
}
