<?php
	use Page\PageType;
?>
<div id="edit-attribute-modal" class="modal" tabindex="-1">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Edit an Existing Attribute</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<form id="edit-page-attribute-form">
					<div class="input-group mb-2">
						<label for="edit-attribute-name-input" class="input-group-text">
							<span>Attribute Name</span>
						</label>
						<input class="form-control" id="edit-attribute-name-input" name="name">
					</div>
					<div>
						<h4>Available on Page Type(s):</h4>
						<div>
							<?php
								foreach(PageType::cases() as $pageTypeCase){
									?>
									<div class="form-check form-switch">
										<input class="form-check-input edit-page-type-checkbox" type="checkbox" role="switch" id="edit-page-type-checkbox-<?= $pageTypeCase->name ?>" data-page-type="<?= $pageTypeCase->name ?>">
										<label class="form-check-label" for="edit-page-type-checkbox-<?= $pageTypeCase->name ?>"><?= ucfirst(strtolower($pageTypeCase->name)) ?></label>
									</div>
									<?php
								}
							?>
						</div>
					</div>
				</form>
				<div id="edit-attribute-loader" class="text-center" style="display:none;">
					<div style="width:6.5rem; height:6.5rem;" class="spinner-border"></div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
				<button type="submit" form="edit-page-attribute-form" class="btn btn-primary">
					<i class="bi bi-node-plus-fill"></i>
					<span>Save Attribute</span>
				</button>
			</div>
		</div>
	</div>
</div>