<?php

?>
@Layout = "backend-basic.php"
@Head{
	<title>Manage Custom Page Attributes</title>
	<script type="module" src="/uplift-assets/js/page-attributes/ManagePageAttributes.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header">
							<h2 class="mb-0">Manage Custom Page Attributes</h2>
						</div>
						<div class="card-body">
							<div>
								<p>
									Page attributes are a versatile and scalable method to assign custom page data to page types that can be stored on a per-page basis. For example, you can create an "Author" page attribute that is only for blog types. Each blog page would then be able to have this field created per-page, and you can use shortcodes or PHP code to retrieve a page attribute for a page.
								</p>
							</div>
							<form id="page-attributes-query-form">
								<div class="d-flex">
									<div class="flex-grow-1 pe-2">
										<div class="input-group">
											<label class="input-group-text" for="attribute-query-input">
												<i class="me-1 bi bi-search"></i>
												<span>Search</span>
											</label>
											<input id="attribute-query-input" type="text" class="form-control" name="query" placeholder="Search attributes by name">
										</div>
									</div>
									<div>
										<button id="new-attribute-button" type="button" class="btn btn-outline-primary">
											<i class="bi bi-plus-circle"></i>
											<span>New Attribute</span>
										</button>
									</div>
								</div>
							</form>
							<hr>
							<div class="text-end">
								<div class="paginator-container"></div>
							</div>
							<div id="no-results" style="display:none;">
								<div class="text-center">
									<em>No results</em>
								</div>
							</div>
							<div id="loader">
								<div class="text-center">
									<div class="spinner-border text-primary" style="width:5rem; height:5rem;"></div>
								</div>
							</div>
							<table id="page-attributes-table" style="display:none;" class="table">
								<thead>
									<tr class="page-attribute-columns">
										<th>
											Row ID
										</th>
										<th>
											Attribute Name
										</th>
										<th>
											Page Types Allowed
										</th>
										<th></th>
									</tr>
								</thead>
								<tbody id="results-container"></tbody>
							</table>
							<div class="text-end">
								<div class="paginator-container"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include __DIR__ . "/modals/new-attribute-modal.php" ?>
	<?php include __DIR__ . "/modals/edit-attribute-modal.php" ?>
}