@Layout = "backend-basic.php"
@Head{
	<title>Sitemap Manager</title>
	<script defer src="/uplift-assets/js/_external/ace-editor/src-min-noconflict/ace.js"></script>
	<script type="module" src="/uplift-assets/js/manage-sitemaps/SitemapManager.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 mb-0">
									Sitemap Manager
								</h2>
								<button class="btn btn-success" id="new-sitemap-modal-trigger-button">
									<i class="bi bi-plus-circle-fill"></i>
									<span>Add New Sitemap</span>
								</button>
							</div>
						</div>
						<div class="card-body">
							<div class="mb-3">
								<p>
									By default, Uplift will have an automatically generate sitemap living on the /sitemap.xml URI route. You can override it by adding a sitemap at that URI route below.
								</p>
								<p>
									You can also add additional sitemaps to submit to Google below.
								</p>
							</div>
							<div id="sitemaps-rows-headers" class="sitemaps-columns">
								<div class="name">
									<strong>Name</strong>
								</div>
								<div class="route">
									<strong>Route</strong>
								</div>
								<div class="content-type">
									<strong>Content Type</strong>
								</div>
								<div class="management-buttons"></div>
							</div>
							<div id="sitemaps-loader" class="text-center">
								<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
									<span class="visually-hidden">Loading...</span>
								</div>
							</div>
							<div id="sitemaps-rows-container"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include __DIR__ . "/modals/new-sitemap-modal.html" ?>
	<?php include __DIR__ . "/modals/edit-sitemap-modal.html" ?>
}