<?php

	/** @var array $viewScope */

	use Nox\ORM\ColumnQuery;
	use Roles\Permission;
	use Roles\PermissionCategories;use Roles\Role;

	/** @var Role $role */
	$role = $viewScope['role'];

	/** @var Permission[] $permissions */
	$permissions = $viewScope['permissions']

?>
@Layout = "backend-basic.php"
@Head{
	<title>Managing <?= $role->name; ?> Role</title>
	<script defer src="/uplift-assets/js/_external/popper.js"></script>
	<?= \Uplift\Vite\ViteStaticService::Use([
    	new \App\Vite\ViteResource("/uplift-core/resources/static/ts/ManageRoles/View/ManageRole.ts", "ManageRole")
	]) ?>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<h2 class="mb-0">
								Managing Role
							</h2>
						</div>
						<div class="card-body">
							<p>
								Manage the role's name and permissions. Click the toggles to enable or disable the permissions assigned to this role. Click the save button after editing the role.
							</p>
							<form id="edit-role-form" autocomplete="off">
								<input type="hidden" name="role-id" id="role-id" value="<?= $role->id; ?>">
								<div class="row">
									<div class="col-6">
										<div class="mb-3 input-group">
											<label for="role-name" class="input-group-text">Name</label>
											<input autocomplete="off" type="text" class="form-control" name="role-name" id="role-name" value="<?= $role->name; ?>">
										</div>
									</div>
								</div>
								<h3><i class="bi bi-lock-fill"></i> Permissions for this Role</h3>
								<div class="input-group">
									<div class="role-permission-check-container mt-2">
										<div class="form-check form-switch">
											<input class="form-check-input" type="checkbox" role="switch" id="all-perms-input" name="has-all-perms" <?= $role->hasAllPermissions === 1 ? "checked" : "" ?>>
											<label class="form-check-label" for="all-perms-input">Super Admin - Has All Permissions</label>
										</div>
									</div>
								</div>
								<hr>
								<div class="row mb-3">
									<?php
										foreach(PermissionCategories::cases() as $permissionCategory) {
											$isChecked = false;

											// Check if this permission category is enabled
											foreach ($permissions as $permission){
												if ($permission->permissionID === $permissionCategory->value){
													$isChecked = $permission->isEnabled;
													break;
												}
											}

											?>
											<div class="role-permission-check-container">
												<div class="form-check form-switch">
													<input class="perm-checkbox form-check-input" type="checkbox" role="switch" id="permission-<?= $permissionCategory->value ?>" name="<?= $permissionCategory->value ?>" <?= $isChecked ? "checked" : ""; ?>>
													<label class="form-check-label" for="permission-<?= $permissionCategory->value ?>"><?= PermissionCategories::PERMISSION_NAMES[$permissionCategory->value] ?></label>
												</div>
											</div>
											<?php
										}
									?>
								</div>
							</form>
						</div>
						<div class="card-footer d-flex justify-content-between">
							<button id="delete-role-modal-button" class="btn btn-danger">
								<i class="bi bi-trash3-fill"></i>
								<span>Delete Role</span>
							</button>
							<button id="edit-role-submit-button" form="edit-role-form" type="submit" class="btn btn-success">
								<i class="bi bi-check-circle-fill"></i>
								<span>Save</span>
							</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include_once __DIR__ . "/modals/delete-role-modal.php" ?>
}
